import java.util.Hashtable;

import jp.co.prism.xrf.accessor.MakeJobFileException;
import jp.co.prism.xrf.accessor.XRFApi;
import jp.co.prism.xrf.accessor.XRFApiConfig;
import jp.co.prism.xrf.accessor.XRFApiException;


/**
 * ̃vÓAXRFApi̒[ƃWut@C̃TvvOłB
 */
public class XRFApiSample {


    public static void main( String[] args ) {

        // XRFApi#makeReport
        sample1();

        // XRFApi#makeReport
        sample2();

        // XRFApi#makeReport
        sample3();

        // XRFApi#makePrintJobFile
        sample4();

        // XRFApi#makePrintJobFile
        sample5();

        // XRFApi#makePrintJobFile
        sample6();

        System.exit(0);
    }


    /**
     * XPFƃ[Uf[^AXRFt@CPDFt@C𐶐܂B
     */
    static void sample1(){

        try {
            // XRFApiCX^X𐶐
            XRFApi api = XRFApiConfig.getInstance( "../conf/conf.xml" );


            // ****************
            // *  ̓f[^
            // ****************
            // [I[oCAXPFt@C
            String xpfFile = "../data/XPF/Sample_A01_CardType.xpf";

            // [Uf[^AXMLt@C
            String userData = "../data/XML/Sample_A01_CardType.xml";

            // [p[^
            Hashtable params = new Hashtable() ;


            // *****************
            // *  XRF 𐶐
            // *****************
            // o̓[hXRFɐݒ肷B
            params.put( XRFApiConfig.OUTPUTMODE, XRFApiConfig.OUTPUTMODE_XRF );

            //o͐AXRFt@C
            String xrfFile = "../output/XRF/Sample_A01_CardType.xrf";

            // XRF 
            api.makeReport( xpfFile, userData, params, xrfFile );


            // *****************
            // *  PDF 𐶐
            // *****************
            //o̓[hPDFɐݒ肷B
            params.put( XRFApiConfig.OUTPUTMODE, XRFApiConfig.OUTPUTMODE_PDF );

            //o͐APDFt@C
            String pdfFile = "../output/PDF/Sample_A01_CardType.pdf";

            // PDF 
            api.makeReport( xpfFile, userData, params, pdfFile );

        }
        catch ( XRFApiException e ) {
            e.printStackTrace();
        }
    }


    /**
     * _Ci~bNI[oCXRF𐶐
     */
    static void sample2(){

        try {
            //XRFApiCX^X𐶐
            XRFApi api = XRFApiConfig.getInstance( "../conf/conf.xml" );

            // ****************
            // *  ̓f[^
            // ****************
            // [I[oCAXPFt@C
            String[] xpfFiles = new String[]{
                    "../data/XPF/Sample_A01_CardType.xpf",
                    "../data/XPF/Sample_A02_DenpyoType_1.xpf",
                    "../data/XPF/Sample_A03_DenpyoType_2.xpf",
                    "../data/XPF/Sample_A04_DenpyoType_3.xpf",
                    "../data/XPF/Sample_A05_ListType.xpf"
            };

            // [Uf[^AXMLt@C
            String[] userData = new String[]{
                    "../data/XML/Sample_A01_CardType.xml",
                    "../data/XML/Sample_A02_DenpyoType_1.xml",
                    "../data/XML/Sample_A03_DenpyoType_2.xml",
                    "../data/XML/Sample_A04_DenpyoType_3.xml",
                    "../data/XML/Sample_A05_ListType.xml"
            };

            // [p[^
            Hashtable[] params = new Hashtable[5];
            params[0] = new Hashtable();
            params[1] = new Hashtable();
            params[2] = new Hashtable();
            params[3] = new Hashtable();
            params[4] = new Hashtable();
            // o̓[hXRFɐݒ肷B
            params[0].put( XRFApiConfig.OUTPUTMODE, XRFApiConfig.OUTPUTMODE_XRF );
            // XRFt@C̈pTCYw肷
            params[0].put( XRFApiConfig.PRINTSIZE, XRFApiConfig.PRINTSIZE_A4 );
            params[1].put( XRFApiConfig.PRINTSIZE, XRFApiConfig.PRINTSIZE_B5 );
            params[2].put( XRFApiConfig.PRINTSIZE, XRFApiConfig.PRINTSIZE_A4 );
            params[3].put( XRFApiConfig.PRINTSIZE, XRFApiConfig.PRINTSIZE_A4 );
            params[4].put( XRFApiConfig.PRINTSIZE, XRFApiConfig.PRINTSIZE_A3 );

            //o͐AXRFt@C
            String outputFile = "../output/XRF/XRFApiSample2.xrf";

            // XRF 
            api.makeReport( xpfFiles, userData, params, outputFile ) ;

        } catch ( XRFApiException e ) {
            e.printStackTrace();
        }
    }


    /**
     * AXRFt@CPDFt@C𐶐܂B
     */
    static void sample3(){

        try {
            // XRFApiCX^X𐶐
            XRFApi api = XRFApiConfig.getInstance( "../conf/conf.xml" );

            // [I[oCAXPFt@C
            String[] xpfFiles = {
                    "Sample_A01_CardType.xpf",
                    "Sample_A02_DenpyoType_1.xpf",
                    "Sample_A03_DenpyoType_2.xpf",
                    "Sample_A04_DenpyoType_3.xpf",
                    "Sample_A05_ListType.xpf",
                    "Sample_A06_LabelType_1.xpf",
                    "Sample_A07_LabelType_2.xpf",
                    "Sample_B01_BukkenJoho.xpf",
                    "Sample_B02_Graph.xpf",
                    "Sample_B04_Nouhin.xpf",
                    "Sample_B05_Nouhin_Cycle.xpf"
            };

            // [Uf[^AXMLt@C
            String[] userDatas = {
                    "Sample_A01_CardType.xml",
                    "Sample_A02_DenpyoType_1.xml",
                    "Sample_A03_DenpyoType_2.xml",
                    "Sample_A04_DenpyoType_3.xml",
                    "Sample_A05_ListType.xml",
                    "Sample_A06_LabelType_1.xml",
                    "Sample_A07_LabelType_2.xml",
                    "Sample_B01_BukkenJoho.xml",
                    "Sample_B02_Graph.xml",
                    "Sample_B04_Nouhin.xml",
                    "Sample_B05_Nouhin_Cycle.xml"
            };

            // [Uf[^AXMLt@C
            String[] reportFiles = {
                    "Sample_A01_CardType",
                    "Sample_A02_DenpyoType_1",
                    "Sample_A03_DenpyoType_2",
                    "Sample_A04_DenpyoType_3",
                    "Sample_A05_ListType",
                    "Sample_A06_LabelType_1",
                    "Sample_A07_LabelType_2",
                    "Sample_B01_BukkenJoho",
                    "Sample_B02_Graph",
                    "Sample_B04_Nouhin",
                    "Sample_B05_Nouhin_Cycle"
            };

            // [p[^
            Hashtable params = new Hashtable() ;

            // 
            for( int i = 0; i < xpfFiles.length; i++ ){

                String xpfFile  = "../data/XPF/" + xpfFiles[i];
                String userData = "../data/XML/" + userDatas[i];
                String xrfFile = "../output/XRF/" + reportFiles[i] + ".xrf";
                String pdfFile = "../output/PDF/" + reportFiles[i] + ".pdf";

                // XRF 
                params.put( XRFApiConfig.OUTPUTMODE, XRFApiConfig.OUTPUTMODE_XRF );
                // XRFt@CɈWuZbg܂B
                params.put( XRFApiConfig.JOBNAME, reportFiles[i] );
                api.makeReport( xpfFile, userData, params, xrfFile );

                // PDF 
                params.put( XRFApiConfig.OUTPUTMODE, XRFApiConfig.OUTPUTMODE_PDF );
                api.makeReport( xpfFile, userData, params, pdfFile );
            }

        } catch ( XRFApiException e ) {
            e.printStackTrace();
        }
    }


    /**
     * XRFt@CAWut@C𐶐܂B
     */
    static void sample4(){

        try {
            // XRFApiCX^X𐶐
            XRFApi api = XRFApiConfig.getInstance( "../conf/conf.xml" );

            // XRFt@C
            String[] xrfFiles = {
                    "../output/XRF/Sample_A01_CardType.xrf",
                    "../output/XRF/Sample_A02_DenpyoType_1.xrf",
                    "../output/XRF/Sample_A03_DenpyoType_2.xrf"
            };

            // Wut@Co͐
            String jobFile = "../output/XJF/PrintJob1.xjf";

            // **********************
            // *  Wut@C̐
            // **********************
            api.makePrintJobFile( xrfFiles, jobFile );

        }
        catch (MakeJobFileException e) {
            e.printStackTrace();
        }
        catch (XRFApiException e) {
            e.printStackTrace();
        }
    }


    /**
     * Wut@Cp[^ŖOȂǂw肵AWut@C𐶐܂B
     */
    static void sample5(){

        try {
            // XRFApiCX^X𐶐
            XRFApi api = XRFApiConfig.getInstance( "../conf/conf.xml" );

            // XRFt@C
            String[] xrfFiles = {
                    "../output/XRF/Sample_A01_CardType.xrf",
                    "../output/XRF/Sample_A02_DenpyoType_1.xrf",
                    "../output/XRF/Sample_A03_DenpyoType_2.xrf"
            };

            // Wut@Cp[^
            Hashtable jobfileParam = new Hashtable();

            // Wut@C̖OZbgiFileł͂܂j
            jobfileParam.put( XRFApiConfig.JOBFILE_NAME_KEY, "JobName" );

            // Wut@C̃O|[g̃xfobOɐݒ
            jobfileParam.put( XRFApiConfig.JOBFILE_CLIENT_LOGREPORT_LEVEL_KEY,
                    XRFApiConfig.JOBFILE_CLIENT_LOGREPORT_LEVEL_DEBUG );

            // Wut@C̊gZbgiO|[gŏo͂j
            jobfileParam.put( XRFApiConfig.JOBFILE_EXTINFO_KEY_PREFIX+"COMMENT",
                    "maked by XRF Composer samplecode." );

            // Wut@Co͐
            String jobFile = "../output/XJF/PrintJob2.xjf";

            // **********************
            // **  Wut@C̐
            // **********************
            api.makePrintJobFile( xrfFiles, jobfileParam, jobFile );

        }
        catch (MakeJobFileException e) {
            e.printStackTrace();
        }
        catch (XRFApiException e) {
            e.printStackTrace();
        }
    }


    /**
     * [f[^AXRF𐶐AWut@C𐶐܂B
     */
    static void sample6(){

        try {
            // XRFApiCX^X𐶐
            XRFApi api = XRFApiConfig.getInstance( "../conf/conf.xml" );

            // ****************
            // *  [f[^
            // ****************
            // XPFt@C
            String[] xpfFiles = {
                    "../data/XPF/Sample_A01_CardType.xpf",
                    "../data/XPF/Sample_A02_DenpyoType_1.xpf",
                    "../data/XPF/Sample_A03_DenpyoType_2.xpf"
            };
            // [Uf[^t@C
            String[] userdata = {
                    "../data/XML/Sample_A01_CardType.xml",
                    "../data/XML/Sample_A02_DenpyoType_1.xml",
                    "../data/XML/Sample_A03_DenpyoType_2.xml"
            };

            // [p[^
            Hashtable params = new Hashtable() ;
            params.put( XRFApiConfig.OUTPUTMODE, XRFApiConfig.OUTPUTMODE_XRF );
            Hashtable[] reportParams = { params, params, params };

            // o͐
            String jobFile = "../output/XJF/PrintJob3.xjf";

            // **********************
            // *  [̐ 
            // *  Wut@C̐
            // **********************
            api.makePrintJobFile( xpfFiles, userdata, reportParams, jobFile );

        }
        catch (MakeJobFileException e) {
            e.printStackTrace();
        }
        catch (XRFApiException e) {
            e.printStackTrace();
        }
    }

}
