import java.io.File;
import java.util.Hashtable;

import jp.co.prism.xrf.accessor.MakeJobFileException;
import jp.co.prism.xrf.accessor.XRFApiConfig;
import jp.co.prism.xrf.accessor.XRFApiException;
import jp.co.prism.xrf.launchbroker.RemoteLaunchBroker;
import jp.co.prism.xrf.launchbroker.XRFRemoteLaunchBroker;
import jp.co.prism.xrf.launchbroker.XRFRemoteLaunchBrokerException;


/**
 * ̃vÓAXRFRemoteLaunchBroker̒[ƃWut@C̃TvvOłB
 *
 */
public class XRFRLBSample {


    public static void main(String[] args) {

        // XRFRemoteLaunchBroker#toPrint
        sample1();

        // XRFRemoteLaunchBroker#toView
        sample2();

        // XRFRemoteLaunchBroker#fromMakeToPrint
        sample3();

        // XRFRemoteLaunchBroker#sendJobFile
        sample4();

        // XRFRemoteLaunchBroker#toPrintByJobFile
        sample5();

        System.exit(0);
    }


    /**
     * XRFt@CA[JɂXRF Readerɑ΂AvitoPrintjs܂B
     */
    static void sample1(){

        try{
            // RLBCX^X
            XRFRemoteLaunchBroker launchBroker = new RemoteLaunchBroker();

            // XRFt@C
            String xrfFile = "../output/XRF/Sample_A01_CardType.xrf";

            // XRF ReaderQƂ邽߂̃t@CpXłA
            // ł́AXRF Reader̓[Jł邽߁A΃pX擾܂B
            String requestXrfFile = new File( xrfFile ).getAbsolutePath();

            // XRF Reader̓삵Ă}ṼzXg܂IPAhX
            String readerHost = "localhost";

            // XRF ReaderĎ|[gԍ
            String readerPort = "44444";

            // \Pbg^CAEg[msec]
            String socketTimeout = "60000";

            // [gv
            launchBroker.toPrint( requestXrfFile, readerHost, readerPort, socketTimeout );

        }catch (XRFRemoteLaunchBrokerException e){
            e.printStackTrace();
        }
    }


    /**
     * XRFt@CA[JɂXRF Readerɑ΂Aʕ\itoViewjs܂B
     */
    static void sample2(){

        try{
            // RLBCX^X
            XRFRemoteLaunchBroker launchBroker = new RemoteLaunchBroker();

            // ʕ\XRFt@C
            String xrfFile = "../output/XRF/Sample_A01_CardType.xrf";

            // XRF ReaderQƂ邽߂̃t@CpXłA
            // ł́AXRF Reader̓[Jł邽߁A΃pX擾܂B
            String requestXrfFile = new File( xrfFile ).getAbsolutePath();

            // XRF Reader̓삵Ă}ṼzXg܂IPAhX
            String readerHost = "localhost";

            // XRF ReaderĎ|[gԍ
            String readerPort = "44444";

            // \Pbg^CAEg[msec]
            String socketTimeout = "60000";

            // [gʕ\v
            launchBroker.toView( requestXrfFile, readerHost, readerPort, socketTimeout );

        }catch (XRFRemoteLaunchBrokerException e){
            e.printStackTrace();
        }
    }

    /**
     * XRFt@C̐ifromMakeToPrintj܂łs܂B
     * ́A[JɂXRF Readerɑ΂Av܂B
     * AꂽXRF͍폜܂B
     */
    static void sample3(){

        try{
            // RLBCX^X
            XRFRemoteLaunchBroker launchBroker = new RemoteLaunchBroker();

            // [I[oCAXPFt@C
            String xpfFile = "../data/XPF/Sample_A01_CardType.xpf";

            // [Uf[^AXMLt@C
            String userData = "../data/XML/Sample_A01_CardType.xml";

            // [p[^
            Hashtable params = new Hashtable();
            params.put( XRFApiConfig.OUTPUTMODE, XRFApiConfig.OUTPUTMODE_XRF );
            // XRFt@CɈWuZbg܂B
            params.put( XRFApiConfig.JOBNAME, "XRFRLBSample3" );

            // XRFt@C̈ꎞo͐
            String xrfFile = "../output/XRF/temp/XRFRLBSample3.xrf";

            // XRF ReaderQƂ邽߂̃t@CpXłA
            // ł́AXRF Reader̓[Jł邽߁A΃pX擾܂B
            String requestXrfFile = new File( xrfFile ).getAbsolutePath();

            // XRF Reader̓삵Ă}ṼzXg܂IPAhX
            String readerHost = "localhost";

            // XRF ReaderĎ|[gԍ
            String readerPort = "44444";

            // \Pbg^CAEg[msec]
            String socketTimeout = "60000";

            // XRFt@C̐܂łs
            launchBroker.fromMakeToPrint( "../conf/conf.xml",
                    xpfFile, userData, params, xrfFile,
                    requestXrfFile, readerHost, readerPort, socketTimeout);

        }catch (XRFRemoteLaunchBrokerException e){
            e.printStackTrace();
        } catch ( XRFApiException e ) {
            e.printStackTrace();
        }
    }


    /**
     * Wut@CA[JɂXRF Readerɑ΂AsvisendJobFilejs܂B
     */
    static void sample4(){

        try{
            // RLBCX^X
            XRFRemoteLaunchBroker launchBroker = new RemoteLaunchBroker();

            // Wut@C
            String jobFile = "../output/XJF/PrintJob1.xjf";

            // XRF ReaderQƂ邽߂̃t@CpXłA
            // ł́AXRF Reader̓[Jł邽߁A΃pX擾܂B
            String requestJobFile = new File( jobFile ).getAbsolutePath();

            // XRF Reader̓삵Ă}ṼzXg܂IPAhX
            String readerHost = "localhost";

            // XRF ReaderĎ|[gԍ
            String readerPort = "44444";

            // \Pbg^CAEg[msec]
            String socketTimeout = "60000";

            // [gv
            launchBroker.sendJobFile( requestJobFile, readerHost, readerPort, socketTimeout );

        }catch (XRFRemoteLaunchBrokerException e){
            e.printStackTrace();
        }
    }

    /**
     * Wut@C̐itoPrintByJobFilej܂łs܂B
     * ́A[JɂXRF Readerɑ΂Av܂B
     * AꂽWut@C͍폜܂B
     */
    static void sample5(){
        try{
            // RLBCX^X
            XRFRemoteLaunchBroker launchBroker = new RemoteLaunchBroker();

            // XRFt@C
            String[] xrfFiles = {
                    "../output/XRF/Sample_A01_CardType.xrf",
                    "../output/XRF/Sample_A02_DenpyoType_1.xrf",
                    "../output/XRF/Sample_A03_DenpyoType_2.xrf",
                    "../output/XRF/Sample_A04_DenpyoType_3.xrf"};

            // Wut@Cp[^
            Hashtable jobfileParam = new Hashtable();

            //Wut@CɖOiFileł͂Ȃj
            jobfileParam.put(XRFApiConfig.JOBFILE_NAME_KEY, "XRFRLBSample5");

            //Wut@C̃O|[g̃xfobOɐݒ
            jobfileParam.put(XRFApiConfig.JOBFILE_CLIENT_LOGREPORT_LEVEL_KEY,
                    XRFApiConfig.JOBFILE_CLIENT_LOGREPORT_LEVEL_DEBUG);

            //Wut@C̊gZbgiO|[gŏo͂j
            jobfileParam.put(XRFApiConfig.JOBFILE_EXTINFO_KEY_PREFIX
                    +"COMMENT", "comment.");

            // Wut@C
            String jobFile = "../output/XJF/temp/XRFRLBSample5.xjf";

            // XRF ReaderQƂ邽߂̃t@CpXłA
            // ł́AXRF Reader̓[Jł邽߁A΃pX擾܂B
            String requestJobFile = new File( jobFile ).getAbsolutePath();

            // XRF Reader̓삵Ă}ṼzXg܂IPAhX
            String readerHost = "localhost";

            // XRF ReaderĎ|[gԍ
            String readerPort = "44444";

            // \Pbg^CAEg[msec]
            String socketTimeout = "60000";

            // [gv
            launchBroker.toPrintByJobFile( "../conf/conf.xml",
                    xrfFiles, jobfileParam, jobFile,
                    requestJobFile, readerHost, readerPort, socketTimeout);

        }catch (MakeJobFileException e){
            e.printStackTrace();
        }catch (XRFRemoteLaunchBrokerException e){
            e.printStackTrace();
        }
    }
}
